/*
 * Examples  : Arduino Experiment Examples By....ETT CO.,LTD
 * Program   : MCP3424_MultiChannelConversion
 * Hardware  : ET-EASY MEGA1280 (Arduino Mega Compatible)
 *           : ET-MINI MCP3424 I2C Interface with Arduino  
 * Function  : Measure ADC Voltage
 */

#include <Wire.h>                           // I2C Bus
#include <MCP3424.h>                        // MCP3424 Library

MCP3424 MCP(0);                             // Setup MCP3424 Hardware Address = 0
long Voltage[4];                            // Array used to store results

void setup()
{ 
  Serial.begin(9600);                       // start serial for output
}

void loop()
{  
  for(int i=1; i<=4; i++)
  {
    MCP.Configuration(i,                    // ADC Channel(1,2,3,4) = 1..4
                      18,                   // Resolution(12,14,16,18) = 18-Bit
                      1,                    // ADC Mode(0,1) = 1:Continous mode
                      1);                   // Amplifier gain(1,2,4,8) = 1

    Voltage[i-1] = MCP.Measure();           // Measure is stocked in array Voltage, note that the library will wait for a completed conversion that takes around 200 ms@18bits

    Serial.print("Channel ");               // print results
    Serial.print(i);
    Serial.print(" : ");  
    Serial.print(Voltage[i-1]);
    Serial.println(" microVolt");
  }         
  delay (1000);
}

